<?php

namespace App\Exports\SuperAdmin;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class TherapistMainCategoriesExport implements FromArray, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    protected $therapist_main_categories;
    public function __construct($therapist_main_categories)
    {
        $this->therapist_main_categories = $therapist_main_categories;
    }
    public function array(): array
    {
        $data = [];
        foreach ($this->therapist_main_categories as $therapist_main_categories) {
            $single = [$therapist_main_categories->id, $therapist_main_categories->name, $therapist_main_categories->description,$therapist_main_categories->icon,$therapist_main_categories->image, $therapist_main_categories->is_active, $therapist_main_categories->slug, date_format($therapist_main_categories->created_at, 'd-m-Y')];
            $data[] = $single;
        }
        return $data;
    }
    public function headings(): array
    {
        return ["id", "name", "description","icon","image", "is_active", "slug", "created_at"];
    }
}
